/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ServerboundEditMusicLabelPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EditMusicLabelScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("etched", "textures/gui/edit_music_label.png");
    private static final ResourceLocation LABEL = new ResourceLocation("etched", "textures/gui/label.png");
    private static final Component TITLE_COMPONENT = Component.m_237115_((String)"screen.etched.edit_music_label.title");
    private static final Component AUTHOR_COMPONENT = Component.m_237115_((String)"screen.etched.edit_music_label.author");
    private final Player player;
    private final InteractionHand hand;
    private final ItemStack labelStack;
    private final int imageWidth = 176;
    private final int imageHeight = 139;
    private Button doneButton;
    private EditBox title;
    private EditBox author;

    public EditMusicLabelScreen(Player player, InteractionHand hand, ItemStack stack) {
        super(TITLE_COMPONENT);
        this.player = player;
        this.hand = hand;
        this.labelStack = stack;
    }

    protected void m_7856_() {
        int leftPos = (this.f_96543_ - this.imageWidth) / 2;
        int topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.saveChanges();
            this.f_96541_.m_91152_(null);
        }).m_252987_(leftPos, topPos + this.imageHeight + 5, this.imageWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
        this.title = new EditBox(this.f_96547_, leftPos + 10, topPos + 91, 154, 10, TITLE_COMPONENT);
        this.title.m_94144_(SimpleMusicLabelItem.getTitle(this.labelStack));
        this.title.m_94205_(-1);
        this.title.m_94202_(-1);
        this.title.m_94199_(128);
        this.title.m_94182_(false);
        this.title.m_94190_(true);
        this.title.m_93692_(true);
        this.m_7522_((GuiEventListener)this.title);
        this.author = new EditBox(this.f_96547_, leftPos + 10, topPos + 121, 154, 10, AUTHOR_COMPONENT);
        this.author.m_94144_(SimpleMusicLabelItem.getAuthor(this.labelStack));
        this.author.m_94205_(-1);
        this.author.m_94202_(-1);
        this.author.m_94199_(128);
        this.author.m_94182_(false);
        this.author.m_94190_(true);
        this.title.m_94151_(string -> {
            if ((this.author.m_94155_().isEmpty() || string.isEmpty()) && this.doneButton.f_93623_) {
                this.doneButton.f_93623_ = false;
            } else if (!(this.author.m_94155_().isEmpty() || string.isEmpty() || this.doneButton.f_93623_)) {
                this.doneButton.f_93623_ = true;
            }
        });
        this.m_142416_((GuiEventListener)this.title);
        this.author.m_94151_(string -> {
            if ((this.title.m_94155_().isEmpty() || string.isEmpty()) && this.doneButton.f_93623_) {
                this.doneButton.f_93623_ = false;
            } else if (!(this.title.m_94155_().isEmpty() || string.isEmpty() || this.doneButton.f_93623_)) {
                this.doneButton.f_93623_ = true;
            }
        });
        this.m_142416_((GuiEventListener)this.author);
    }

    public void m_6574_(Minecraft minecraft, int i, int j) {
        String title = this.title.m_94155_();
        String author = this.author.m_94155_();
        boolean titleFocused = this.title.m_93696_();
        boolean authorFocused = this.author.m_93696_();
        GuiEventListener focused = this.m_7222_();
        this.m_6575_(minecraft, i, j);
        this.title.m_94144_(title);
        this.title.m_93692_(titleFocused);
        this.author.m_94144_(author);
        this.author.m_93692_(authorFocused);
        this.m_7522_(focused);
    }

    public void m_86600_() {
        this.title.m_94120_();
        this.author.m_94120_();
    }

    protected void renderBg(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int primaryLabelColor;
        this.m_280273_(graphics);
        int leftPos = (this.f_96543_ - this.imageWidth) / 2;
        int topPos = (this.f_96544_ - this.imageHeight) / 2;
        graphics.m_280218_(TEXTURE, leftPos, topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.m_280614_(this.f_96547_, TITLE_COMPONENT, leftPos + 7, topPos + 77, 0x404040, false);
        graphics.m_280614_(this.f_96547_, AUTHOR_COMPONENT, leftPos + 7, topPos + 77 + 30, 0x404040, false);
        int secondaryLabelColor = primaryLabelColor = 0xFFFFFF;
        if (this.labelStack.m_41720_() instanceof MusicLabelItem) {
            secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(this.labelStack);
        } else if (this.labelStack.m_41720_() instanceof ComplexMusicLabelItem) {
            primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(this.labelStack);
            secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(this.labelStack);
        }
        RenderSystem.setShaderColor((float)((float)(primaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(primaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        graphics.m_280218_(LABEL, leftPos, topPos, 0, 0, this.imageWidth, 70);
        RenderSystem.setShaderColor((float)((float)(secondaryLabelColor >> 16 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor >> 8 & 0xFF) / 255.0f), (float)((float)(secondaryLabelColor & 0xFF) / 255.0f), (float)1.0f);
        graphics.m_280218_(LABEL, leftPos, topPos, 0, 70, this.imageWidth, 70);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void saveChanges() {
        String author = this.author.m_94155_().trim();
        String title = this.title.m_94155_().trim();
        SimpleMusicLabelItem.setTitle(this.labelStack, title);
        SimpleMusicLabelItem.setAuthor(this.labelStack, author);
        int slot = this.hand == InteractionHand.MAIN_HAND ? this.player.m_150109_().f_35977_ : 40;
        EtchedMessages.PLAY.sendToServer((Object)new ServerboundEditMusicLabelPacket(slot, author, title));
    }
}

